<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Auth;

use Illuminate\Http\Request;
use DB;
use App\Models\Classes;
use App\Models\Student;
use App\Models\Semester;
use App\Models\SubjectGroup;
use App\Models\User;
use Barryvdh\DomPDF\Facade\Pdf;
use DNS1D; // For 1D barcodes
use DNS2D; // For 2D barcodes


class DashboardController extends Controller
{

	public function id_card($type=NULL){
	    switch($type){
	        case 'students':
	            $data['breadcrumbs'] = [
        			    ['link' => "id_cards/students", 'name' => "ID Card Students"]
        			];
        
        		$data['classes'] = Classes::select('id', 'class')
        			->where('status', 1)->get();
        		$data['semesters'] = Semester::select('id', 'semester_title')
        			->get();
        		return view('/content/pages/page-idcard-students', $data);
    	            break;
    	   case 'staffs':
    	            
    	        break;
	   }
    }
    
    public function id_card_post(Request $request){
		$data['breadcrumbs'] = [
			['link' => "subject/groups", 'name' => "ID Card Students"]
		];
		$data['students'] = Student::select('students.id', 'students.admission_no', 'students.roll_no', 'students.name','students.primary_mobile','students.dob', 'students.blood_group', 'students.present_house_no', 'students.present_address','students.present_village','students.present_city','students.present_district','students.present_state', 'students.present_pincode', 'students.permanent_house_no', 'students.permanent_address', 'students.permanent_village', 'students.permanent_city', 'students.permanent_district', 'students.permanent_state', 'students.permanent_pincode', 'classes.class')
		                        ->leftJoin('classes', 'classes.id', '=', 'students.class_id')
			                    ->where('students.class_id', $request->class_id)
			                    ->where('students.semester_id', $request->semester_id)
			                    ->where('students.status', '=', '1')
			                    ->get()->toArray();
		//dd($data);
		/*$i = 0;
		foreach($data['students'] as $st){
		    $barcode = new BarcodeController();
            $data['students'][$i]['barcode'] = $barcode->generate($data['students'][$i]['roll_no']);
            $i++;
		}
		dd($data);*/
		
		/*return view('/content/pdf/id-card-students',$data);*/
		$customPaper = array(0, 0, 323, 516);
        $pdf = PDF::loadView('/content/pdf/id-card-students', $data)->setPaper($customPaper, 'landscape');;
        return $pdf->download('ID_Card.pdf');		
        flush();
	}

    public function id_card_students_by_class($class_id = NULL){
        $data['students'] = Student::select('students.id', 'students.admission_no', 'students.roll_no', 'students.name','students.primary_mobile','students.dob', 'students.blood_group', 'students.present_house_no', 'students.present_address','students.present_village','students.present_city','students.present_district','students.present_state', 'students.present_pincode', 'students.permanent_house_no', 'students.permanent_address', 'students.permanent_village', 'students.permanent_city', 'students.permanent_district', 'students.permanent_state', 'students.permanent_pincode', 'classes.class')
		                        ->leftJoin('classes', 'classes.id', '=', 'students.class_id')
			                    ->where('students.class_id', $class_id)
			                    ->where('students.semester_id', '1')
			                    ->where('students.status', '=', '1')
			                    ->get()->toArray();
								//dd($_SERVER['DOCUMENT_ROOT']);

		// Generate a Code 128 barcode
        $data['barcode'] = DNS1D::getBarcodeHTML('081331723987', 'C128');

        // Generate a QR code
        //$barcode2D = DNS2D::getBarcodeHTML('https://example.com', 'QRCODE');

		/*return view('/id-card-students',$data);*/
        $customPaper = array(0, 0, 323, 516);
        $pdf = PDF::loadView('/id-card-students', $data)->setPaper($customPaper, 'landscape');;
        return $pdf->download('ID_Card.pdf');		
        flush();
    }

}